#include <infra/libs/controller/controller/client_filter_helpers.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(ClientFilterHelpers) {
    Y_UNIT_TEST(GetIndependentAttributesIndices) {
        UNIT_ASSERT_EQUAL(
            GetIndependentAttributesIndices({"/a", "/a/b", "/aa"}),
            TVector<size_t>({0, 2}));
        UNIT_ASSERT_EQUAL(
            GetIndependentAttributesIndices({"/a/b", "/a", "/aa"}),
            TVector<size_t>({1, 2}));
        UNIT_ASSERT_EQUAL(
            GetIndependentAttributesIndices({"/a/b", "/aa", "/a"}),
            TVector<size_t>({2, 1}));
        UNIT_ASSERT_EQUAL(
            GetIndependentAttributesIndices({"/a/b", "/a", "/a"}),
            TVector<size_t>({1}));
    }
}
