#pragma once

#include <infra/libs/error_booster_client/protos/error_booster.pb.h>
#include <infra/libs/logger/eventlog.h>

#include <util/generic/maybe.h>

namespace NInfra::NErrorBoosterClient {

class IConverter {
public:
    // should return Nothing if no conversion is defined
    virtual TMaybe<TErrorBoosterEvent> Convert(const NLogEvent::TEventHeader& header, const NProtoBuf::Message& event) = 0;

    virtual ~IConverter() = default;
};

};
