#pragma once

#include "converter.h"

#include <infra/libs/error_booster_client/protos/config.pb.h>
#include <infra/libs/error_booster_client/protos/error_booster.pb.h>
#include <infra/libs/logger/eventlog.h>

#include <library/cpp/logger/backend.h>
#include <library/cpp/logger/log.h>
#include <library/cpp/logger/priority.h>

#include <util/generic/ptr.h>

namespace NInfra::NErrorBoosterClient {

class TErrorBoosterClient {
public:
    TErrorBoosterClient(const TErrorBoosterClientConfig& cfg, THolder<IConverter> converter = {});

    void LogEvent(const NLogEvent::TEventHeader& header, const NProtoBuf::Message& event);

    void LogEvent(const TErrorBoosterEvent& errorBoosterEvent);

    void SetConverter(THolder<IConverter> converter);

private:
    bool AcceptLevel(ui32 level) const;

private:
    ELogPriority Level_;
    TString ProjectName_;
    TString File_;
    bool FillAdditionalWithEventContent_;
    THolder<IConverter> Converter_;
    THolder<TLogBackend> Backend_;
    TAtomicSharedPtr<TLog> Logger_;
};

} // namespace NInfra::NErrorBoosterClient
