#pragma once

#include <infra/libs/grpc_server/proto/config.pb.h>

#include <infra/libs/logger/log_frame.h>

#include <contrib/libs/grpc/include/grpc++/grpc++.h>

#include <util/system/condvar.h>
#include <util/system/mutex.h>
#include <util/thread/pool.h>

namespace NInfra {

class TGrpcServer {
public:
    TGrpcServer(const TGrpcServerConfig& config);
    ~TGrpcServer();

    void RegisterService(grpc::Service* service);

    void Start(NInfra::TLogFramePtr logFrame);

    void Stop(NInfra::TLogFramePtr logFrame);

    void Wait(NInfra::TLogFramePtr logFrame);

    void Shutdown(NInfra::TLogFramePtr logFrame);

    static TString AddressFromConfig(const TGrpcServerConfig& config);

private:
    const TString Address_;
    grpc::ServerBuilder ServerBuilder_;
    THolder<grpc::Server> Server_;

    TMutex Mutex_;
    TCondVar CondVar_;
    bool Shutdown_ = false;
};

} // namespace NInfra
