#pragma once

#include <infra/libs/http_service/protos/config.pb.h>
#include <infra/libs/logger/logger.h>

#include <infra/libs/service_iface/router.h>

#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/response.h>

namespace NInfra {

class IProfileStatsCallbacks {
public:
    class TProfileStats {
    public:
        bool IsCompressed = false;
        ui64 CompressedSize = 0;
        ui64 DecompressedSize = 0;
        TDuration ProcessingTime = TDuration::Zero();
    };

    void OnRequestBuild(const TProfileStats&) {}
    void OnResponseBuild(const TProfileStats&) {}
};

using TProfileStatsCallbacksPtr = THolder<IProfileStatsCallbacks>;

class IHttpServiceCallbacks {
public:
    virtual void OnFailRequest(int /*failstate*/) {}

    virtual void OnException() {}

    virtual void OnMaxConn() {}

    virtual void OnResponseBuild(const THttpResponse& /*response*/) {}

    virtual ~IHttpServiceCallbacks() = default;
};

using THttpServiceCallbacksPtr = THolder<IHttpServiceCallbacks>;

class THttpClientFactory: public THttpServer::ICallBack {
public:
    THttpClientFactory(IRequestRouter& router, TProfileStatsCallbacksPtr&& profileCallbacks, THttpServiceCallbacksPtr&& callbacks)
        : Router_(router)
        , ProfileStatsCallbacks_(std::move(profileCallbacks))
        , Callbacks_(std::move(callbacks))
    {
    }

    TClientRequest* CreateClient() override;

    void OnFailRequest(int /*failstate*/) override;

    void OnException() override;

    void OnMaxConn() override;

private:
    IRequestRouter& Router_;
    TProfileStatsCallbacksPtr ProfileStatsCallbacks_;
    THttpServiceCallbacksPtr Callbacks_;
};

class THttpService {
public:
    THttpService(const THttpServiceConfig& config, TRequestRouterPtr router, TProfileStatsCallbacksPtr&& profileCallbacks = MakeHolder<IProfileStatsCallbacks>(), THttpServiceCallbacksPtr&& callbacks = MakeHolder<IHttpServiceCallbacks>())
        : Config_(config)
        , Router_(router)
        , ClientFactory_(*Router_, std::move(profileCallbacks), std::move(callbacks))
    {
    }

    void Start(TLogFramePtr logFrame);

    void Wait(TLogFramePtr logFrame);

    void ShutDown();

    void Stop();

    size_t GetRequestQueueSize() const;
    size_t GetFailQueueSize() const;

private:
    THttpServiceConfig Config_;
    TRequestRouterPtr Router_;
    THttpClientFactory ClientFactory_;
    THolder<THttpServer> HttpServer_;
};

} // namespace NInfra
