package ru.yandex.infra.controller;

import com.google.common.base.MoreObjects;

import ru.yandex.yt.ytclient.rpc.RpcOptions;

public class YtSettings {

    private final String proxy;
    private final String token;
    private final String user;
    private final RpcOptions rpcOptions;

    public YtSettings(String proxy, String token, String user, RpcOptions rpcOptions) {
        this.proxy = proxy;
        this.token = token;
        this.user = user;
        this.rpcOptions = rpcOptions;
    }

    public String getProxy() {
        return proxy;
    }

    public String getToken() {
        return token;
    }

    public String getUser() {
        return user;
    }

    public RpcOptions getRpcOptions() {
        return rpcOptions;
    }

    public YtSettings withRpcOptions(RpcOptions rpcOptions) {
        return new YtSettings(proxy, token, user, rpcOptions);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("proxy", proxy)
                .add("user", user)
                .toString();
    }
}
