package ru.yandex.infra.controller.concurrent;

import com.codahale.metrics.MetricRegistry;

import ru.yandex.infra.controller.metrics.MetricUtils;
import ru.yandex.qe.telemetry.metrics.Gauges;

public class DummyLeaderService implements LeaderService {
    private boolean isProcessingAllowed = false;

    public DummyLeaderService(MetricRegistry metricRegistry) {
        Gauges.forSupplier(metricRegistry, LEADER_LOCK_METRIC, () -> MetricUtils.booleanToInt(true));
        Gauges.forSupplier(metricRegistry, PROCESSING_ALLOWED_METRIC,
                () -> MetricUtils.booleanToInt(isProcessingAllowed));
    }

    @Override
    public void ensureLeadership() {
    }

    @Override
    public void allowProcessing() {
        isProcessingAllowed = true;
    }

    @Override
    public boolean isProcessingAllowed() {
        return isProcessingAllowed;
    }

    @Override
    public boolean isLeader() {
        return true;
    }

    @Override
    public void addProcessingAllowedCallback(Runnable callback) {
    }

    @Override
    public void addLeadershipAcquiredCallback(Runnable callback) {
    }

    @Override
    public void addLeadershipLostCallback(Runnable callback) {
    }

    @Override
    public Long getCurrentEpoch() {
        return 0L;
    }
}
