package ru.yandex.infra.controller.concurrent;

import ru.yandex.inside.yt.kosher.common.GUID;

public class DummyLockingService implements LockingService {
    private boolean lockCanBeTaken;
    private boolean isLocked = false;
    private GUID transactionId;

    public DummyLockingService(boolean lockCanBeTaken) {
        this.lockCanBeTaken = lockCanBeTaken;
    }

    @Override
    public long lock() {
        if (!lockCanBeTaken) {
            isLocked = false;
            // emulate an unsuccessful lock
            throw new RuntimeException("Lock has been lost");
        } else {
            isLocked = true;
            transactionId = GUID.create();
        }
        return 0;
    }

    @Override
    public boolean isLocked() {
        return isLocked;
    }

    @Override
    public GUID getTransactionId() {
        return transactionId;
    }

    public void setLockCanBeTaken(boolean lockCanBeTaken) {
        this.lockCanBeTaken = lockCanBeTaken;
    }

    public void loseLock() {
        isLocked = false;
        transactionId = null;
    }
}
