package ru.yandex.infra.controller.concurrent;

// Typical interaction cycle looks like this:
// 1. Common replica initialization happens
// 2. ensureLeadership() is called and blocks until it has acquired leadership.
// 3. Leadership is acquired, callbacks are executed, ensureLeadership() returns.
// 4. Leader-specific initialization happens.
// 5. allowProcessing() is called when replica considers itself fully initialized, callbacks are executed (only on first call).
// 6. After some time replica asynchronously detects that it has lost leadership, callbacks are executed
public interface LeaderService {
    String LEADER_LOCK_METRIC = "leader_lock_acquired";
    String PROCESSING_ALLOWED_METRIC = "processing_allowed";
    String EPOCH_METRIC = "current_epoch";
    String METRIC_DELIMITER = ".";

    // Return when replica has acquired and holds leadership
    // Not thread safe
    void ensureLeadership();
    boolean isLeader();
    // Replica state is up to date and it may perform processing
    boolean isProcessingAllowed();
    void allowProcessing();

    void addProcessingAllowedCallback(Runnable callback);
    void addLeadershipAcquiredCallback(Runnable callback);
    void addLeadershipLostCallback(Runnable callback);
    Long getCurrentEpoch();
}
