package ru.yandex.infra.controller.dto;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.client.api.AccessControl;

public class Acl {
    public static final Acl EMPTY = new Acl(Collections.emptyList());

    private final List<AccessControl.TAccessControlEntry> entries;

    public Acl(List<AccessControl.TAccessControlEntry> entries) {
        this.entries = entries;
    }

    public List<AccessControl.TAccessControlEntry> getEntries() {
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Acl)) {
            return false;
        }
        Acl acl = (Acl) o;
        return Objects.equals(Set.copyOf(entries), Set.copyOf(acl.entries));
    }

    @Override
    public int hashCode() {
        return Objects.hash(entries);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("entries", entries)
                .toString();
    }
}
