package ru.yandex.infra.controller.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class MetaWithProject extends SchemaMeta {
    private final String projectId;
    private final String accountId;

    public MetaWithProject(String id, Acl acl, String fqid, String uuid, long creationTime, String projectId,
                           String accountId) {
        super(id, acl, fqid, uuid, creationTime);
        this.projectId = projectId;
        this.accountId = accountId;
    }

    public String getProjectId() {
        return projectId;
    }

    public String getAccountId() {
        return accountId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaWithProject)) {
            return false;
        }
        MetaWithProject that = (MetaWithProject) o;
        return super.equals(o) &&
                Objects.equals(projectId, that.projectId) &&
                Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), projectId, accountId);
    }

    @Override
    public String toString() {
        return addFields(MoreObjects.toStringHelper(this))
                .add("projectId", projectId)
                .add("accountId", accountId)
                .toString();
    }

}
