package ru.yandex.infra.controller.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.client.api.Autogen;

public class ProjectMeta extends SchemaMeta {
    private final String ownerId;

    public ProjectMeta(String id, Acl acl, String fqid, String uuid, long creationTime, String ownerId) {
        super(id, acl, fqid, uuid, creationTime);
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public static ProjectMeta fromProto(Autogen.TProjectMeta proto) {
        return new ProjectMeta(proto.getId(),
                new Acl(proto.getAclList()),
                proto.getFqid(),
                proto.getUuid(),
                proto.getCreationTime(),
                proto.getOwnerId()
        );
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectMeta)) {
            return false;
        }
        ProjectMeta that = (ProjectMeta) o;
        return super.equals(o) &&
                Objects.equals(ownerId, that.ownerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), ownerId);
    }

    @Override
    public String toString() {
        return addFields(MoreObjects.toStringHelper(this))
                .add("ownerId", ownerId)
                .toString();
    }

}

