package ru.yandex.infra.controller.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.client.api.Autogen;

public class RelationMeta extends SchemaMeta {
    private final String fromFqid;
    private final String toFqid;

    public RelationMeta(String id, Acl acl, String fqid, String uuid, long creationTime, String fromFqid, String toFqid) {
        super(id, acl, fqid, uuid, creationTime);
        this.fromFqid = fromFqid;
        this.toFqid = toFqid;
    }

    public String getFromFqid() {
        return fromFqid;
    }

    public String getToFqid() {
        return toFqid;
    }

    public static RelationMeta fromProto(Autogen.TRelationMeta proto) {
        return new RelationMeta(proto.getId(),
                new Acl(proto.getAclList()),
                proto.getFqid(),
                proto.getUuid(),
                proto.getCreationTime(),
                proto.getFromFqid(),
                proto.getToFqid());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationMeta)) {
            return false;
        }
        RelationMeta that = (RelationMeta) o;
        return super.equals(o) &&
                Objects.equals(fromFqid, that.fromFqid) &&
                Objects.equals(toFqid, that.toFqid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), fromFqid, toFqid);
    }

    @Override
    public String toString() {
        return addFields(MoreObjects.toStringHelper(this))
                .add("fromFqid", fromFqid)
                .add("toFqid", toFqid)
                .toString();
    }

}
