package ru.yandex.infra.controller.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.client.api.Autogen.TSchemaMeta;

// Common object meta
public class SchemaMeta {
    private final String id;
    private final String fqid;
    private final String uuid;
    private final Acl acl;
    private final long creationTime;

    public SchemaMeta(String id, Acl acl, String fqid, String uuid, long creationTime) {
        this.id = id;
        this.acl = acl;
        this.fqid = fqid;
        this.uuid = uuid;
        this.creationTime = creationTime;
    }

    public static SchemaMeta fromProto(TSchemaMeta proto) {
        return new SchemaMeta(proto.getId(), new Acl(proto.getAclList()), proto.getFqid(), proto.getUuid(), proto.getCreationTime());
    }

    public String getId() {
        return id;
    }

    public String getFqid() {
        return fqid;
    }

    public String getUuid() {
        return uuid;
    }

    public Acl getAcl() {
        return acl;
    }

    public long getCreationTime() {
        return creationTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaMeta)) {
            return false;
        }
        SchemaMeta that = (SchemaMeta) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(fqid, that.fqid) &&
                Objects.equals(uuid, that.uuid) &&
                Objects.equals(acl, that.acl) &&
                Objects.equals(creationTime, that.creationTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, acl, fqid, uuid, creationTime);
    }

    @Override
    public String toString() {
        return addFields(MoreObjects.toStringHelper(this)).toString();
    }

    protected MoreObjects.ToStringHelper addFields(MoreObjects.ToStringHelper helper) {
        return helper.add("id", id)
                .add("acl", acl)
                .add("fqid", fqid)
                .add("uuid", uuid)
                .add("creationTime", creationTime);
    }
}
