package ru.yandex.infra.controller.dto;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.yp.client.api.Autogen;

public class StageMeta extends MetaWithProject {
    public StageMeta(String id, Acl acl, String fqid, String uuid, long creationTime, String projectId, String accountId) {
        super(id, acl, fqid, uuid, creationTime, projectId, accountId);
    }

    //legacy constructor for testing only (to avoid fixing all usages)
    @VisibleForTesting
    public StageMeta(String id, Acl acl, String fqid, String uuid, long creationTime, String projectId) {
        this(id, acl, fqid, uuid, creationTime, projectId, null);
    }

    public static StageMeta fromProto(Autogen.TStageMeta proto) {
        return new StageMeta(proto.getId(),
                new Acl(proto.getAclList()),
                proto.getFqid(),
                proto.getUuid(),
                proto.getCreationTime(),
                proto.getProjectId(),
                proto.getAccountId()
        );
    }
}
