package ru.yandex.infra.controller.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;

// MetricRegistry modifier methods belong to an implementation, not an interface, so add a wrapper interface around it.
public interface GaugeRegistry {

    Metric register(String name, Metric metric) throws IllegalArgumentException;
    boolean remove(String name);

    default <T> void add(String name, Gauge<T> metric) {
        register(name, metric);
    }

    GaugeRegistry EMPTY = new DummyGaugeRegistry();

    class DummyGaugeRegistry implements GaugeRegistry {
        @Override
        public Metric register(String name, Metric metric) throws IllegalArgumentException {
            return metric;
        }

        @Override
        public boolean remove(String name) {
            return true;
        }
    }

}
