package ru.yandex.infra.controller.metrics;

import java.util.Set;

import com.codahale.metrics.Gauge;

import ru.yandex.qe.telemetry.metrics.yasm.GolovanableImpl;
import ru.yandex.qe.telemetry.metrics.yasm.YasmGauge;

public class GolovanableGauge<T> extends GolovanableImpl implements YasmGauge<T> {
    private final Gauge<T> gauge;

    public GolovanableGauge(Gauge<T> gauge, String aggregation) {
        this(gauge, Set.of(aggregation));
    }

    public GolovanableGauge(Gauge<T> gauge, Set<String> aggregations) {
        super(aggregations);
        this.gauge = gauge;
    }

    @Override
    public T getValue() {
        return gauge.getValue();
    }
}
