package ru.yandex.infra.controller.metrics;

import java.util.Collection;
import java.util.Set;

import com.codahale.metrics.MetricRegistry;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

import ru.yandex.qe.telemetry.metrics.yasm.YasmMeter;

public class Log4j2MetricAppender extends AbstractAppender {

    private transient final MetricRegistry registry;
    private transient final Set<String> aggregations;

    private transient YasmMeter all;
    private transient YasmMeter trace;
    private transient YasmMeter debug;
    private transient YasmMeter info;
    private transient YasmMeter warn;
    private transient YasmMeter error;
    private transient YasmMeter fatal;

    /**
     * Create a new instrumented appender using the given appender name and registry.
     *
     * @param appenderName The name of the appender.
     * @param registry     The metric registry
     * @param aggregations List of required aggregation types
     */
    public Log4j2MetricAppender(MetricRegistry registry, String appenderName, Collection<String> aggregations) {
        super(appenderName, null, null, true);
        this.registry = registry;
        this.aggregations = Set.copyOf(aggregations);
    }

    private YasmMeter createMeter(String meterName) {
        String name = MetricRegistry.name(getName(), meterName);
        YasmMeter meter = new YasmMeter(aggregations);
        return registry.register(name, meter);
    }

    @Override
    public void start() {
        this.all = createMeter("all");
        this.trace = createMeter("trace");
        this.debug = createMeter("debug");
        this.info = createMeter("info");
        this.warn = createMeter("warn");
        this.error = createMeter("error");
        this.fatal = createMeter("fatal");
        super.start();
    }

    @Override
    public void append(LogEvent event) {
        all.mark();
        switch (event.getLevel().getStandardLevel()) {
            case TRACE:
                trace.mark();
                break;
            case DEBUG:
                debug.mark();
                break;
            case INFO:
                info.mark();
                break;
            case WARN:
                warn.mark();
                break;
            case ERROR:
                error.mark();
                break;
            case FATAL:
                fatal.mark();
                break;
            default:
                break;
        }
    }
}
