package ru.yandex.infra.controller.metrics;

import java.util.HashMap;
import java.util.Map;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;

public class MapGaugeRegistry implements GaugeRegistry {
    private final Map<String, Metric> metrics = new HashMap<>();

    @Override
    public Metric register(String name, Metric metric) throws IllegalArgumentException {
        return metrics.put(name, metric);
    }

    @Override
    public boolean remove(String name) {
        return metrics.remove(name) != null;
    }

    public Object getGaugeValue(String name) {
        return ((Gauge<?>)metrics.get(name)).getValue();
    }
}
