package ru.yandex.infra.controller.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;

public class MetricAdapterRegistry implements GaugeRegistry {
    private final MetricRegistry registry;

    public MetricAdapterRegistry(MetricRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Metric register(String name, Metric metric) throws IllegalArgumentException {
        return registry.register(name, metric);
    }

    @Override
    public boolean remove(String name) {
        return registry.remove(name);
    }

}
