package ru.yandex.infra.controller.metrics;

import com.codahale.metrics.Metric;

// Adds a namespace prefix to all metrics
public class NamespacedGaugeRegistry implements GaugeRegistry {
    private final GaugeRegistry decorated;
    private final String prefix;

    public NamespacedGaugeRegistry(GaugeRegistry decorated, String namespace) {
        this.decorated = decorated;
        this.prefix = namespace + ".";
    }

    @Override
    public Metric register(String name, Metric metric) throws IllegalArgumentException {
        return decorated.register(prefix + name, metric);
    }

    @Override
    public boolean remove(String name) {
        return decorated.remove(prefix + name);
    }
}
