package ru.yandex.infra.controller.servlets;

import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpServlet;

import com.typesafe.config.Config;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ServerBuilder.class);

    public static Server buildServer(Config config, Map<String, HttpServlet> servlets) {
        int workerThreads = config.getInt("worker_threads");
        Server server = new Server(new QueuedThreadPool(workerThreads, workerThreads));

        int selectorThreads = config.getInt("selector_threads");
        int port = config.getInt("port");
        ServerConnector connector = new ServerConnector(server, 0, selectorThreads);
        connector.setReuseAddress(true);
        connector.setHost("::");
        connector.setPort(port);
        connector.setIdleTimeout(config.getDuration("connection_timeout", TimeUnit.MILLISECONDS));
        connector.setAcceptQueueSize(config.getInt("accept_backlog_size"));
        server.addConnector(connector);

        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        String rootPath = config.getString("root_path");
        servlets.forEach((name, servlet) -> {
            LOG.info("Listen({}): {}", port, rootPath + name);
            context.addServlet(new ServletHolder(servlet), rootPath + name);
        });
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context, new DefaultHandler()});
        server.setHandler(handlers);
        return server;
    }

}
