package ru.yandex.infra.controller.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import ru.yandex.yp.client.api.AccessControl;

public class AclUtils {
    private AclUtils() {}

    public static final Map<String, AccessControl.EAccessControlPermission> PERMISSION_NAMES = new HashMap<>();
    static {
        PERMISSION_NAMES.put("none", AccessControl.EAccessControlPermission.ACP_NONE);
        PERMISSION_NAMES.put("read", AccessControl.EAccessControlPermission.ACP_READ);
        PERMISSION_NAMES.put("read_secrets", AccessControl.EAccessControlPermission.ACP_READ_SECRETS);
        PERMISSION_NAMES.put("write", AccessControl.EAccessControlPermission.ACA_WRITE);
        PERMISSION_NAMES.put("create", AccessControl.EAccessControlPermission.ACA_CREATE);
        PERMISSION_NAMES.put("ssh_access", AccessControl.EAccessControlPermission.ACA_SSH_ACCESS);
        PERMISSION_NAMES.put("root_ssh_access", AccessControl.EAccessControlPermission.ACA_ROOT_SSH_ACCESS);
        PERMISSION_NAMES.put("use", AccessControl.EAccessControlPermission.ACA_USE);
        PERMISSION_NAMES.put("get_qyp_vm_status", AccessControl.EAccessControlPermission.ACA_GET_QYP_VM_STATUS);
    }

    public static Optional<AccessControl.EAccessControlPermission> permissionToProto(String permission) {
        if (PERMISSION_NAMES.containsKey(permission)) {
            return Optional.of(PERMISSION_NAMES.get(permission));
        }

        return Optional.empty();
    }
}
