package ru.yandex.infra.controller.util;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

import ru.yandex.infra.controller.FailedHttpRequestException;
import ru.yandex.yp.model.YpError;
import ru.yandex.yp.model.YpException;

public class ExceptionUtils {

    private ExceptionUtils() {
    }

    public static Throwable stripCompletionException(Throwable error) {
        while ((error instanceof CompletionException || error instanceof ExecutionException)
                && error.getCause() != null) {
            error = error.getCause();
        }
        return error;
    }

    public static <T extends Throwable> Optional<T> tryExtractExceptionOfType(Throwable error, Class<T> exceptionType) {
        while (error != null) {
            if (exceptionType.isAssignableFrom(error.getClass())) {
                return Optional.of((T)error);
            }

            Throwable cause = error.getCause();
            if (error == cause) {
                break;
            }
            error = cause;
        }
        return Optional.empty();
    }

    public static Optional<YpError> tryExtractYpError(Throwable error) {
        return tryExtractExceptionOfType(error, YpException.class)
                .map(YpException::getYpError);
    }

    public static Optional<Integer> tryExtractHttpErrorCode(Throwable exception) {
        return tryExtractExceptionOfType(exception, FailedHttpRequestException.class)
                .map(FailedHttpRequestException::getResponseCode);
    }
}
