package ru.yandex.infra.controller.util;

import org.apache.logging.log4j.LogManager;

public enum ExitUtils {
    SUCCESS(0),
    EXCEPTION_MAIN(1),
    EXECUTOR_SCHEDULING_FAILURE(2),
    LEADERSHIP_LOST(3),
    WATCHDOG_EXPIRED(4),
    INIT_FAILURE(5);

    final int value;

    ExitUtils(int value) {
        this.value = value;
    }

    public static void gracefulExit(ExitUtils exitCode) {
        try {
            LogManager.shutdown();
        } catch (Exception ignore) {}

        System.exit(exitCode.value);
    }
}
