package ru.yandex.infra.controller.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import NYT.NYson.NProto.ProtobufInterop;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;

import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yp.client.api.Enums;

public class ProtobufEnumWrappers {

    public static final Wrapper<Enums.EPodSshKeySet> POD_SSH_KEY_SET =
            new Wrapper<>(Enums.EPodSshKeySet.getDescriptor(), Enums.EPodSshKeySet::forNumber);

    public static class Wrapper<TEnumType> {

        private final Function<Integer, TEnumType> forNumber;
        private final Map<String, TEnumType> allValuesByName;

        public Wrapper(Descriptors.EnumDescriptor descriptor, Function<Integer, TEnumType> forNumber) {
            this.forNumber = forNumber;
            allValuesByName = new HashMap<>();
            for(var enumValueDescriptor: descriptor.getValues()) {
                DescriptorProtos.EnumValueOptions options = enumValueDescriptor.getOptions();
                String enumValueName = options.hasExtension(ProtobufInterop.enumValueName) ?
                        options.getExtension(ProtobufInterop.enumValueName) :
                        enumValueDescriptor.getName();
                allValuesByName.put(enumValueName, forNumber.apply(enumValueDescriptor.getNumber()));
            }
        }

        public TEnumType tryParseEnumValue(YTreeNode node) {
            if (node == null) {
                return null;
            } else if (node.isIntegerNode()) {
                return forNumber.apply(node.intValue());
            } else if (node.isStringNode()) {
                return allValuesByName.get(node.stringValue());
            }
            return null;
        }
    }

}
