package ru.yandex.infra.controller.util;

import java.io.IOException;
import java.io.InputStream;

import com.google.common.base.Charsets;
import org.apache.commons.io.IOUtils;

public class ResourceUtils {
    private ResourceUtils() {}

    public static String readResource(String name) {
        try (InputStream is = ResourceUtils.class.getClassLoader().getResourceAsStream(name)) {
            return IOUtils.toString(is, Charsets.UTF_8.name());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
