package ru.yandex.infra.controller.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.typesafe.config.ConfigList;

public class StringUtils {
    private StringUtils() {
    }

    public static final String ID_SEPARATOR = ".";
    public static final String ID_SEPARATOR_REGEX = "\\.";

    public static String joinStrings(Collection<String> ids) {
        return ids.stream()
                .map(item -> "'" + item + "'")
                .collect(Collectors.joining(", "));
    }

    public static List<String> unwrapStringList(ConfigList list) {
        return list.unwrapped().stream()
                .map(item -> (String) item)
                .collect(Collectors.toList());
    }
}
