package ru.yandex.infra.controller.util;

import java.util.List;

import com.google.protobuf.ByteString;

import ru.yandex.inside.yt.kosher.impl.ytree.serialization.YTreeBinarySerializer;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;
import ru.yandex.yp.model.YpPayload;

public class YsonUtils {

    public static YpPayload toYsonPayload(YTreeNode ytree) {
        return YpPayload.yson(ByteString.copyFrom(ytree.toBinary()));
    }

    public static YTreeNode payloadToYson(YpPayload payload) {
        return YTreeBinarySerializer.deserialize(payload.getYson().get().newInput());
    }

    public static String parseId(List<YpPayload> payloads) {
        return YTreeBinarySerializer.deserialize(payloads.get(0).getYson().get().newInput()).stringValue();
    }
}
