package ru.yandex.infra.controller.yp;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

import com.google.protobuf.Message;

import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.yp.YpRawObjectService;
import ru.yandex.yp.model.YpObjectType;
import ru.yandex.yp.model.YpTypedId;

public class DummyYpObjectRepository<Meta extends SchemaMeta, Spec extends Message, Status extends Message>
        implements YpObjectRepository<Meta, Spec, Status> {
    public YpObjectType objectType;
    public List<String> createdIds = new ArrayList<>();
    public List<String> updatedIds = new ArrayList<>();
    public List<String> removedIds = new ArrayList<>();
    public List<String> savedStatusIds = new ArrayList<>();
    public List<String> getObjectsRequestIds = new ArrayList<>();
    public List<String> getObjectRequestIds = new ArrayList<>();
    public List<CreateObjectRequest<Spec>> createObjectRequestSpecs = new ArrayList<>();
    public Map<String, Status> lastSavedStatuses = new HashMap<>();
    public Optional<Long> lastUsedListAllIdsTimestamp;
    public Optional<Long> lastUsedListIdsTimestamp;

    public int selectCallsCount;
    public int watchCallsCount;
    public int getObjectsCallsCount;

    public CompletableFuture<YpTypedId> createResponse = new CompletableFuture<>();
    public CompletableFuture<?> updateResponse = new CompletableFuture<>();
    public UpdateYpObjectRequest<Spec, Status> lastUpdateRequest = new UpdateYpObjectRequest.Builder<Spec, Status>().build();
    public CompletableFuture<?> removeResponse = new CompletableFuture<>();
    public CompletableFuture<Boolean> saveStatusResponse = new CompletableFuture<>();
    public Supplier<CompletableFuture<Boolean>> saveStatusResponseSupplier = null;
    public Function<List<String>, CompletableFuture<List<Optional<YpObject<Meta, Spec, Status>>>>> getObjectsResponseSupplier = null;
    public Map<String, CompletableFuture<Optional<YpObject<Meta, Spec, Status>>>> getResponses = new HashMap<>();
    public CompletableFuture<SelectedObjects<Meta, Spec, Status>> selectResponse = new CompletableFuture<>();
    public CompletableFuture<WatchedObjects> watchResponse = new CompletableFuture<>();
    public CompletableFuture<List<Optional<YpObject<Meta, Spec, Status>>>> getObjectsResponse = new CompletableFuture<>();
    public CompletableFuture<Set<String>> listAllIdsResponse = new CompletableFuture<>();
    public CompletableFuture<Set<String>> listIdsResponse = new CompletableFuture<>();

    @Override
    public YpObjectType getObjectType() {
        return objectType;
    }

    @Override
    public CompletableFuture<YpTypedId> createObject(String id, CreateObjectRequest<Spec> spec) {
        createdIds.add(id);
        createObjectRequestSpecs.add(spec);
        return createResponse;
    }

    @Override
    public CompletableFuture<?> updateObject(String id, UpdateYpObjectRequest<Spec, Status> request) {
        updatedIds.add(id);
        lastUpdateRequest = request;
        return updateResponse;
    }

    @Override
    public CompletableFuture<?> removeObject(String id) {
        removedIds.add(id);
        return removeResponse;
    }

    @Override
    public CompletableFuture<Optional<YpObject<Meta, Spec, Status>>> getObject(String id, Selector selector) {
        getObjectRequestIds.add(id);
        return getResponses.get(id);
    }

    @Override
    public CompletableFuture<List<Optional<YpObject<Meta, Spec, Status>>>> getObjects(List<String> ids, Selector selector) {
        getObjectsCallsCount++;
        getObjectsRequestIds = new ArrayList<>(ids);
        return getObjectsResponseSupplier != null ? getObjectsResponseSupplier.apply(ids) : getObjectsResponse;
    }

    @Override
    public CompletableFuture<SelectedObjects<Meta, Spec, Status>> selectObjects(
            Selector selector, Map<String, String> labelsForFilter) {
        selectCallsCount++;
        return selectResponse;
    }

    @Override
    public CompletableFuture<WatchedObjects> watchObjects(Long startTimestamp, Duration timeLimit) {
        watchCallsCount++;
        return watchResponse;
    }

    @Override
    public CompletableFuture<Boolean> saveStatus(String id, UpdateYpObjectRequest<Spec, Status> request) {
        savedStatusIds.add(id);
        lastSavedStatuses.put(id, request.getStatus().get());
        return saveStatusResponseSupplier != null ? saveStatusResponseSupplier.get() : saveStatusResponse;
    }

    @Override
    public CompletableFuture<Set<String>> listAllIds(Optional<Long> timestamp, Map<String, String> labelsForFilter) {
        lastUsedListAllIdsTimestamp = timestamp;
        return listAllIdsResponse;
    }

    @Override
    public YpRawObjectService getRawClient() {
        return null;
    }

    @Override
    public CompletableFuture<Set<String>> listIds(Optional<Long> timestamp) {
        lastUsedListIdsTimestamp = timestamp;
        return listIdsResponse;
    }
}
