package ru.yandex.infra.controller.yp;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;

import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.yp.model.YpTransaction;
import ru.yandex.yp.model.YpTypedId;

public class DummyYpObjectTransactionalRepository<Meta extends SchemaMeta, Spec extends Message, Status extends Message>
         extends DummyYpObjectRepository<Meta, Spec, Status> implements YpObjectTransactionalRepository<Meta, Spec, Status> {

    final private DummyYpTransactionClient ypTransactionClient = new DummyYpTransactionClient();

    public Long lastUsedSelectObjectsTimestamp;
    public Long lastUsedWatchObjectsTimestamp;

    public Map<Long, CompletableFuture<List<Optional<YpObject<Meta, Spec, Status>>>>> getObjectsTransactionalResponse =
            new HashMap<>();
    public CompletableFuture<Long> generateTimestampResponse = new CompletableFuture<>();

    @Override
    public YpTransactionClient getTransactionClient() {
        return ypTransactionClient;
    }

    @Override
    public CompletableFuture<YpTypedId> createObject(String id, YpTransaction transaction, CreateObjectRequest<Spec> request) {
        return createObject(id, request);
    }

    @Override
    public CompletableFuture<?> updateObject(String id, YpTransaction transaction,
            UpdateYpObjectRequest<Spec, Status> request) {
        return updateObject(id, request);
    }

    @Override
    public CompletableFuture<?> removeObject(String id, YpTransaction transaction) {
        return removeObject(id);
    }

    @Override
    public CompletableFuture<Optional<YpObject<Meta, Spec, Status>>> getObject(String id,
            Long timestamp, Selector selector) {
        return getObject(id, selector);
    }

    @Override
    public CompletableFuture<List<Optional<YpObject<Meta, Spec, Status>>>> getObjects(List<String> ids,
            Selector selector, Long timestamp) {
        getObjectsCallsCount++;
        getObjectsRequestIds = new ArrayList<>(ids);
        return getObjectsTransactionalResponse.get(timestamp);
    }

    @Override
    public CompletableFuture<SelectedObjects<Meta, Spec, Status>> selectObjects(
            Selector selector, Map<String, String> labelsForFilter, Long endTimestamp) {
        lastUsedSelectObjectsTimestamp = endTimestamp;
        return selectObjects(selector, labelsForFilter);
    }

    @Override
    public CompletableFuture<WatchedObjects> watchObjects(Long startTimestamp, Long endTimestamp, Duration timeLimit) {
        return watchObjects(startTimestamp, timeLimit);
    }

    @Override
    public CompletableFuture<WatchedObjects> watchObjects(long startTimestamp, Optional<Long> endTimestamp) {
        watchCallsCount++;
        lastUsedWatchObjectsTimestamp = startTimestamp;
        return watchResponse;
    }

    @Override
    public CompletableFuture<Long> generateTimestamp() {
        return generateTimestampResponse;
    }
}
