package ru.yandex.infra.controller.yp;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import ru.yandex.yp.YpRawObjectService;
import ru.yandex.yp.model.YpTransaction;

public class DummyYpTransactionClient implements YpTransactionClient {
    public int commitTransactionCallsCount = 0;

    @Override
    public YpRawObjectService getYpRawObjectService() {
        return null;
    }

    public CompletableFuture<YpTransaction> startTransaction() {
        return CompletableFuture.completedFuture(new YpTransaction("id", 0, 0));
    }

    public CompletableFuture<?> commitTransaction(YpTransaction transaction) {
        commitTransactionCallsCount++;
        return CompletableFuture.completedFuture(0);
    }

    public CompletableFuture<?> runWithTransaction(Function<YpTransaction, CompletableFuture<?>> function) {
        return startTransaction()
                .thenCompose(transaction -> function.apply(transaction).thenApply(x -> transaction))
                .whenComplete((result, error) -> {
                    if (error == null) {
                        commitTransaction(result);
                    }
                    else {
                        abortTransaction(result);
                    }
                });
    }

    public CompletableFuture<?> abortTransaction(YpTransaction transaction) {
        return CompletableFuture.completedFuture(0);
    }
}
