package ru.yandex.infra.controller.yp;

import java.util.function.Function;
import java.util.function.Supplier;

import com.google.protobuf.Message;

import ru.yandex.infra.controller.dto.SchemaMeta;

// Description of protobuf parsers for object
public class ObjectBuilderDescriptor<ProtoMeta extends Message, DtoMeta extends SchemaMeta> {
    private final Supplier<Message.Builder> specBuilder;
    private final Supplier<Message.Builder> statusBuilder;
    private final Function<ProtoMeta, DtoMeta> metaConverter;
    private final ProtoMeta defaultProtoMeta;

    public ObjectBuilderDescriptor(Supplier<Message.Builder> specBuilder, Supplier<Message.Builder> statusBuilder,
            Function<ProtoMeta, DtoMeta> metaConverter, ProtoMeta defaultProtoMeta) {
        this.specBuilder = specBuilder;
        this.statusBuilder = statusBuilder;
        this.metaConverter = metaConverter;
        this.defaultProtoMeta = defaultProtoMeta;
    }

    public DtoMeta createMeta(Function<Message.Builder, Message> protoMetaCreator) {
        Message.Builder builder = defaultProtoMeta.newBuilderForType();
        return metaConverter.apply((ProtoMeta)protoMetaCreator.apply(builder));
    }

    public Message.Builder createSpecBuilder() {
        return specBuilder.get();
    }

    public Message.Builder createStatusBuilder() {
        return statusBuilder.get();
    }
}
