package ru.yandex.infra.controller.yp;

import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;
import com.google.protobuf.Message;

import ru.yandex.bolts.collection.Try;
import ru.yandex.infra.controller.dto.SchemaMeta;

public class SelectedObjects<Meta extends SchemaMeta, Spec extends Message, Status extends Message> {
    final private Map<String, Try<YpObject<Meta, Spec, Status>>> objects;
    final private Long timestamp;

    public SelectedObjects(Map<String, Try<YpObject<Meta, Spec, Status>>> objects, Long timestamp) {
        this.objects = objects;
        this.timestamp = timestamp;
    }

    public Map<String, Try<YpObject<Meta, Spec, Status>>> getObjects() {
        return objects;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SelectedObjects)) return false;
        SelectedObjects<Meta, Spec, Status> selectedObjects = (SelectedObjects<Meta, Spec, Status>) o;
        return objects.equals(selectedObjects.objects) &&
                timestamp.equals(selectedObjects.timestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(objects, timestamp);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("objects", objects)
                .add("timestamp", timestamp)
                .toString();
    }
}
