package ru.yandex.infra.controller.yp;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.model.YpEvent;

public class WatchedObjects {
    final private Map<String, List<YpEvent>> events;
    final private Long timestamp;

    public WatchedObjects(Map<String, List<YpEvent>> events, Long timestamp) {
        this.events = events;
        this.timestamp = timestamp;
    }

    public Map<String, List<YpEvent>> getEvents() {
        return events;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof WatchedObjects)) return false;
        WatchedObjects watchedObjects = (WatchedObjects) o;
        return events.equals(watchedObjects.events) &&
                timestamp.equals(watchedObjects.timestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(events, timestamp);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("events", events)
                .add("timestamp", timestamp)
                .toString();
    }
}
