package ru.yandex.infra.controller.yp;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;

import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.yp.model.YpObjectType;
import ru.yandex.yp.model.YpTypedId;

// A YP-based repository of single type of objects
public interface YpObjectRepository<Meta extends SchemaMeta, Spec extends Message, Status extends Message>
        extends YpObjectStatusRepository<Spec, Status> {
    YpObjectType getObjectType();

    CompletableFuture<YpTypedId> createObject(String id, CreateObjectRequest<Spec> request);

    default CompletableFuture<?> updateObjectSpec(String id, Spec spec) {
        return updateObject(id, new UpdateYpObjectRequest.Builder<Spec, Status>().setSpec(spec).build());
    }

    CompletableFuture<?> updateObject(String id, UpdateYpObjectRequest<Spec, Status> request);

    CompletableFuture<?> removeObject(String id);

    CompletableFuture<Optional<YpObject<Meta, Spec, Status>>> getObject(String id, Selector selector);

    CompletableFuture<List<Optional<YpObject<Meta, Spec, Status>>>> getObjects(List<String> ids, Selector selector);

    CompletableFuture<SelectedObjects<Meta, Spec, Status>> selectObjects(Selector selector, Map<String, String> labelsForFilter);

    CompletableFuture<WatchedObjects> watchObjects(Long startTimestamp, Duration timeLimit);

    CompletableFuture<Set<String>> listIds(Optional<Long> timestamp);

    CompletableFuture<Set<String>> listAllIds(Optional<Long> timestamp, Map<String, String> labelsForFilter);

    default CompletableFuture<Set<String>> listAllIds(long timestamp) {
        return listAllIds(Optional.of(timestamp), Collections.emptyMap());
    }

    default CompletableFuture<Set<String>> listAllIds() {
        return listAllIds(Optional.empty(), Collections.emptyMap());
    }
}
