package ru.yandex.infra.controller.yp;

import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;

import ru.yandex.yp.YpRawObjectService;

public interface YpObjectStatusRepository<Spec extends Message, Status extends Message> {
    // true if was really saved, false if object has been removed
    default CompletableFuture<Boolean> saveStatus(String id, Status status) {
        return saveStatus(id, new UpdateYpObjectRequest.Builder<Spec, Status>().setStatus(status).build());
    }

    CompletableFuture<Boolean> saveStatus(String id, UpdateYpObjectRequest<Spec, Status> request);

    YpRawObjectService getRawClient();
}
