package ru.yandex.infra.controller.yp;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;

import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.yp.model.YpTransaction;
import ru.yandex.yp.model.YpTypedId;

public interface YpObjectTransactionalRepository<Meta extends SchemaMeta, Spec extends Message, Status extends Message>
        extends YpObjectRepository<Meta, Spec, Status> {
    YpTransactionClient getTransactionClient();

    CompletableFuture<YpTypedId> createObject(String id, YpTransaction transaction, CreateObjectRequest<Spec> request);

    CompletableFuture<?> updateObject(String id, YpTransaction transaction, UpdateYpObjectRequest<Spec, Status> request);

    CompletableFuture<?> removeObject(String id, YpTransaction transaction);

    CompletableFuture<Optional<YpObject<Meta, Spec, Status>>> getObject(String id, Long timestamp, Selector selector);

    CompletableFuture<List<Optional<YpObject<Meta, Spec, Status>>>> getObjects(List<String> ids, Selector selector,
            Long timestamp);

    CompletableFuture<SelectedObjects<Meta, Spec, Status>> selectObjects(Selector selector,
            Map<String, String> labelsForFilter, Long endTimestamp);

    CompletableFuture<WatchedObjects> watchObjects(Long startTimestamp, Long endTimestamp, Duration timeLimit);

    CompletableFuture<WatchedObjects> watchObjects(long startTimestamp, Optional<Long> endTimestamp);

    CompletableFuture<Long> generateTimestamp();
}
