package ru.yandex.infra.controller.yp;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import ru.yandex.yp.YpRawObjectService;
import ru.yandex.yp.model.YpTransaction;

public interface YpTransactionClient {
    YpRawObjectService getYpRawObjectService();
    CompletableFuture<YpTransaction> startTransaction();
    CompletableFuture<?> commitTransaction(YpTransaction transaction);
    CompletableFuture<?> runWithTransaction(Function<YpTransaction, CompletableFuture<?>> function);
    CompletableFuture<?> abortTransaction(YpTransaction transaction);
}
