package ru.yandex.infra.controller.yp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class YpUtils {
    private YpUtils() {
    }

    public static List<String> getSelectedPaths(Selector selector) {
        List<String> result = new ArrayList<>();
        if (selector.hasMeta()) {
            result.add(Paths.META);
        }
        if (selector.hasSpec()) {
            result.add(Paths.SPEC);
        }
        if (selector.hasStatus()) {
            result.add(Paths.STATUS);
        }
        if (selector.hasAllLabels()) {
            result.add(Paths.LABELS);
        }
        selector.getAnnotations().forEach(annotation -> result.add(Paths.ANNOTATIONS + Paths.DELIMITER + annotation));
        selector.getRequiredLabelKeys().forEach(label -> result.add(Paths.LABELS + Paths.DELIMITER + label));

        return result;
    }

    public static String getFilterQuery(String filter, Map<String, String> labels) {
        StringBuilder builder = new StringBuilder();
        labels.forEach((key, value) -> addFilter(builder, String.format("[/labels/%s] = \"%s\"", key, value)));
        if (filter != null && !filter.isBlank()) {
            addFilter(builder, filter);
        }
        return builder.toString();
    }

    private static void addFilter(StringBuilder builder, String filter) {
        if (builder.length() != 0) {
            builder.append(" AND ");
        }
        builder.append(filter);
    }
}
