JAVA_LIBRARY()

JDK_VERSION(11)

OWNER(
    g:deploy
    g:deploy-orchestration
)

INCLUDE(${ARCADIA_ROOT}/library/java/dependency_management.inc)

SET(TYPESAFE_CONFIG_VERSION 1.3.1)
SET(STREAMEX_VERSION 0.6.7)
SET(QE_VERSION 6.3382)
SET(JETTY_VERSION 9.4.18.v20190429)
SET(LOG4J_VERSION 2.16.0)
SET(METRICS_VERSION 3.1.2)
SET(LOGSTASH_LOGBACK_ENCODER 4.11)
SET(LOGBACK 1.2.3)

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/junit/junit-bom/5.5.2/junit-bom.bom.inc)
PEERDIR(
    library/java/svnversion
    iceberg/inside-yt

    yp/java/yp

    contrib/java/com/typesafe/config/${TYPESAFE_CONFIG_VERSION}
    contrib/java/one/util/streamex/${STREAMEX_VERSION}
    contrib/java/org/junit/jupiter/junit-jupiter-api
    contrib/java/org/eclipse/jetty/jetty-server/${JETTY_VERSION}
    contrib/java/org/eclipse/jetty/jetty-servlet/${JETTY_VERSION}
    contrib/java/org/apache/commons/commons-io/1.3.2
    contrib/java/org/apache/logging/log4j/log4j-core/${LOG4J_VERSION}
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl/${LOG4J_VERSION}
    contrib/java/org/apache/logging/log4j/log4j-api/${LOG4J_VERSION}
    contrib/java/net/logstash/logback/logstash-logback-encoder/${LOGSTASH_LOGBACK_ENCODER}
    contrib/java/ch/qos/logback/logback-classic/${LOGBACK}
    contrib/java/ch/qos/logback/logback-core/${LOGBACK}

    contrib/java/org/mockito/mockito-core

    contrib/java/io/dropwizard/metrics/metrics-jvm/${METRICS_VERSION}

    contrib/java/ru/yandex/qe/commons-telemetry/${QE_VERSION}
    contrib/java/ru/yandex/qe/commons-telemetry-yasm/${QE_VERSION}

    yp/yp_proto/yp/client/api/proto
)

EXCLUDE(
    # some clashes inside iceberg-xml
    contrib/java/xml-apis/xml-apis
    contrib/java/log4j/log4j/1.2.17
    contrib/java/com/google/code/findbugs/annotations/2.0.3

    # fix for clash with qe telemetry
    contrib/java/ch/qos/logback/logback-classic
    contrib/java/com/sun/activation/javax.activation/1.2.0
    contrib/java/commons-io/commons-io/2.0.1
    contrib/java/commons-io/commons-io/2.4
    contrib/java/commons-logging/commons-logging
    contrib/java/ch/qos/logback/logback-core
    contrib/java/org/apache/commons/commons-io/1.3.2
    contrib/java/org/slf4j/log4j-over-slf4j
    contrib/java/org/slf4j/slf4j-simple

    contrib/java/net/logstash/logback/logstash-logback-encoder
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl
)

JAVA_SRCS(SRCDIR src/main/java **/*.java)

UBERJAR_PATH_EXCLUDE_PREFIX(
    # fix for DEVTOOLS-5190, see also https://stackoverflow.com/a/6743609
    META-INF/DUMMY.DSA
    META-INF/DUMMY.SF
    META-INF/SAXONICA.RSA
    META-INF/SAXONICA.SF
    # fix for https://stackoverflow.com/q/34945438
    META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat
)

LINT(strict)

NEED_CHECK()

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/org/mockito/mockito-core/3.5.2
)

END()

RECURSE(ut)
