#pragma once

#include <infra/libs/leading_invader/protos/config.pb.h>
#include <infra/libs/outcome/result.h>

#include <infra/libs/outcome/result.h>

namespace NInfra {
namespace NLeadingInvader {

struct TError
{
    TString Reason;
};

struct TLeaderInfo
{
    enum EResolveLeaderStatus
    {
        SUCCEED = 0,
        FAILED = 1,
        NO_LEADER = 2,
    };

    EResolveLeaderStatus LeaderStatus;
    TString Fqdn;
    TString Ip;
};

class ILeadingInvader
{
public:
    virtual TExpected<void, TError> EnsureLeading() = 0;
    virtual TLeaderInfo GetLeaderInfo() const = 0;

    virtual ~ILeadingInvader() = default;
};

using TLeadingInvaderHolder = THolder<ILeadingInvader>;

TLeadingInvaderHolder CreateLeadingInvader(
    const TConfig& config
    , const std::function<void()>& onLockAcquired = []{}
    , const std::function<void()>& onLockLost = []{}
);

} // namespace NLeadingInvader
} // namespace NInfra
