#pragma once

#include <infra/libs/sensors/sensor.h>

#include <util/datetime/cputimer.h>

namespace NInfra::NLifetimeHistogram {

class TLifetimeHistogram {
public:
    TLifetimeHistogram() = default;

    TLifetimeHistogram(TIntrusivePtr<NInfra::THistogramRateSensor> lifetimeHistogram)
        : GetHistogram_([lifetimeHistogram](){ return lifetimeHistogram; })
    {
    }

    TLifetimeHistogram(std::function<TIntrusivePtr<NInfra::THistogramRateSensor>()> getHistogram)
        : GetHistogram_(std::move(getHistogram))
    {
    }

    bool Empty() const {
        return !GetHistogram_.operator bool() || !GetHistogram_();
    }

    TMaybe<ui64> GetDuration() const {
        return DurationTime_;
    }

    void Stop() {
        if (DurationTime_.Empty()) {
            DurationTime_ = LifetimeTimer_.Get().MicroSeconds();
        }
    }

    ~TLifetimeHistogram() {
        Stop();
        if (!Empty()) {
            GetHistogram_()->Add(GetDuration().GetRef());
        }
    }

private:
    std::function<TIntrusivePtr<NInfra::THistogramRateSensor>()> GetHistogram_;
    TSimpleTimer LifetimeTimer_;
    TMaybe<ui64> DurationTime_;
};

enum class EResponseSizeType {
    NOSIZE  = 0  /* "NOSIZE" */,
    TINY    = 1  /* "TINY" */,
    SMALL   = 2  /* "SMALL" */,
    MEDIUM  = 3  /* "MEDIUM" */,
    LARGE   = 4  /* "LARGE" */,
    HUGE_   = 5  /* "HUGE" */,
};

struct TResponseTimeHistogramOptions {
    TStringBuf OperationType;
    NMonitoring::TBucketBounds BucketBounds;
    TVector<std::pair<EResponseSizeType, ui64>> ResponseSizeTypes;
};

constexpr TStringBuf RESPONSE_SIZE = "response_size";
constexpr TStringBuf RESPONSE_TIME = "response_time";
constexpr TStringBuf OPERATION_TYPE = "operation_type";

class TResponseTimeHistogramsHolder {
public:
    TResponseTimeHistogramsHolder(const TSensorGroup& sensorGroup, const TVector<TResponseTimeHistogramOptions>& responseTimeHistograms);

    TLifetimeHistogram GetLifetimeHistogram(TStringBuf operationType, const ui64& responseSize = 0) const;

private:
    THashMap<TString, THashMap<TString, TIntrusivePtr<NInfra::THistogramRateSensor>>> ResponseTimeHistograms_;
    THashMap<TString, TVector<std::pair<TString, ui64>>> ResponseSizeBounds_;
};

} // namespace NInfra::NLifetimeHistogram
