import os

from yp.common import wait
from yp.local import YpInstance
from yt.environment import arcadia_interop
from yt.wrapper.ypath import ypath_join


NODE_CONFIG = {
    "tablet_node": {
        "resource_limits": {
            "tablet_static_memory": 100 * 1024 * 1024,
        }
    }
}


def get_yp_instance(work_path, path, start_proxy=False, **kwargs):
    destination = os.path.join(work_path, "build")
    os.makedirs(destination)
    path = arcadia_interop.prepare_yt_environment(destination)
    os.environ["PATH"] = os.pathsep.join([path, os.environ.get("PATH", "")])

    return YpInstance(
        path,
        local_yt_options=dict(
            enable_debug_logging=True,
            node_config=NODE_CONFIG,
            http_proxy_count=1 if start_proxy else 0
        ),
        **kwargs
    )


def sync_access_control(yp_instance):
    yt_client = yp_instance.create_yt_client()
    with yp_instance.create_client() as yp_client:
        instances_path = ypath_join('//yp', '/master/instances')
        master_addresses = list(yt_client.list(instances_path))

        expected_timestamp = yp_client.generate_timestamp()

        synced_master_addresses = set()

        def is_state_updated():
            for master_address in master_addresses:
                if master_address in synced_master_addresses:
                    continue
                if (
                    yt_client.get(ypath_join(
                        instances_path,
                        master_address,
                        "/orchid/access_control/cluster_state_timestamp"
                    )) > expected_timestamp
                ):
                    synced_master_addresses.add(master_address)
                else:
                    return False
            return True

        wait(is_state_updated, iter=30, sleep_backoff=1)
