import local_yp

from yt.wrapper.common import generate_uuid


def run_test(output_path, scenario, sync_access_control=True, yp_instance_options={}):
    yp_instance = local_yp.get_yp_instance(
        output_path,
        "yp_{}".format(generate_uuid()),
        enable_ssl=True,
        **yp_instance_options
    )
    yp_instance.start()
    if sync_access_control:
        local_yp.sync_access_control(yp_instance)

    try:
        scenario.run_test(yp_instance.yp_client_grpc_address)
    except Exception:
        raise
    finally:
        yp_instance.stop()
