#include "hasher.h"

#include <library/cpp/digest/crc32c/crc32c.h>
#include <library/cpp/digest/old_crc/crc.h>

namespace NInfra {

ui32 Get32BitHash(const char* data, size_t len) {
    return crc32(data, len);
}

ui8 GetOneByteHash(const char* data, size_t len) {
    ui16 hash = crc16(data, len);
    return (hash + (hash >> 8)) & 0xFF;
}

}
