#pragma once

#include "event_iterator.h"

#include <util/generic/string.h>
#include <util/system/types.h>
#include <util/stream/output.h>

namespace NInfra {

namespace NPrivate {
    void PrintVersionAndExit();

    void PrintEvents(
        const TIteratorOptions &options
        , bool humanReadable
        , bool printTimestampDiff
        , bool printFrameId
        , bool colorlessOutput = false
        , bool prettyPrint = false
        , bool printSourceLocation = true
    );

    void PrintLastNEvents(
        const TIteratorOptions &options
        , size_t cnt
        , IOutputStream& out
        , bool humanReadable
        , bool printTimestampDiff
        , bool printFrameId
        , bool colorlessOutput = false
        , bool prettyPrint = false
        , bool printSourceLocation = true
    );
}

int PrintEventLog(int argc, const char* argv[]);

} // namespace NInfra
