#pragma once

#include "log_frame.h"

#include <infra/libs/logger/protos/config.pb.h>
#include <infra/libs/logger/protos/events.ev.pb.h>

#include <library/cpp/logger/backend.h>

#include <util/generic/maybe.h>

namespace NInfra {

class TLogger {
public:
    TLogger(TLoggerConfig config, std::function<void()> onWriteFail = []{});

    void SetLevel(ELogPriority level) {
        AtomicSet(*Level_, level);
    }

    void CloseLog() {
        Logger_->CloseLog();
    }

    void ReopenLog() {
        Logger_->ReopenLog();
    }

    TLogFramePtr SpawnFrame() {
        return MakeAtomicShared<TLogFrame>(Logger_, ErrorBoosterClient_, AtomicIncrement(FramesCount_), Level_, Format_);
    }

    TAtomicSharedPtr<NErrorBoosterClient::TErrorBoosterClient> GetErrorBoosterClient() const {
        return ErrorBoosterClient_;
    }

private:
    const TLoggerConfig::ELogFormat Format_;
    THolder<TLogBackend> Backend_;
    THolder<TLogBackend> UnifiedAgentLogBackend_;
    TAtomicSharedPtr<TLog> Logger_;
    TAtomicSharedPtr<NErrorBoosterClient::TErrorBoosterClient> ErrorBoosterClient_;
    TAtomic FramesCount_ = 0;
    TAtomicSharedPtr<TAtomic> Level_;
};

} // namespace NInfra
