#pragma once

#include <infra/libs/logger/logger.h>

#include <mapreduce/yt/interface/logging/logger.h>

#include <util/generic/ptr.h>

namespace NInfra {

////////////////////////////////////////////////////////////////////////////////

class TYtLogger;
using TYtLoggerPtr = TIntrusivePtr<TYtLogger>;

////////////////////////////////////////////////////////////////////////////////

TYtLoggerPtr InitYtLogger(TLoggerConfig config, std::function<void()> onWriteFail = []{});

////////////////////////////////////////////////////////////////////////////////

class TYtLogger
    : public NYT::ILogger
    , private TLogger
{
public:
    TYtLogger(TLoggerConfig config, std::function<void()> onWriteFail = []{});

    void Log(
        NYT::ILogger::ELevel level,
        const TSourceLocation& sourceLocation,
        const char* format,
        va_list args
    ) override;

    using TLogger::ReopenLog;
    using TLogger::GetErrorBoosterClient;

private:
    TLogFramePtr LogFrame_;
};

////////////////////////////////////////////////////////////////////////////////

} // namespace NInfra
