
from infra.libs.monitoring_lib.docs_builder.alert.description import AlertDescription, JuggleCheckDescription, SolomonAlertDescription
from infra.libs.monitoring_lib.docs_builder.basic.builder import BasicDocsBuilder
from infra.libs.monitoring_lib.docs_builder.basic.description import VanillaPage, VanillaSection

from dataclasses import dataclass


class AlertDocsBuilder(BasicDocsBuilder):
    @dataclass
    class Options:
        path_to_docs: str
        path_in_docs: str = "developers"
        docs_name: str = None
        juggler_check_description: type = JuggleCheckDescription
        solomon_alert_desctiption: type = SolomonAlertDescription

    def __init__(self, options: Options):
        pages = {
            VanillaPage(
                name='alerts',
                title='Описание алертов',
                sections=[
                    VanillaSection(options.juggler_check_description, "Juggler проверки"),
                    VanillaSection(options.solomon_alert_desctiption, "Solomon алерты"),
                ]
            ): [AlertDescription],
        }
        super().__init__(options.path_to_docs, pages, options.path_in_docs, options.docs_name)
